100 rem + ************************************************************************ +
102 rem *<                               DotRename                                >*
104 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
106 rem *       Convert extension separator dot to underscore or vice versa        *
108 rem *                                                                          *
110 rem * Works on a single file, a directory or a directory tree                  *
112 rem + ------------------------------------------------------------------------ +
114 rem * V2.00 Fixed bug re extensions > 3 chars                                  *
116 rem * V3.00, pjw, 2025 Apr 22, Rewrite                                         *
118 rem *             External refs removed. More error checking                   *
120 rem * V4.00, pjw, 2025 Sep 01, rewrite of interface                            *
122 rem * V4.01, pjw, 2026 Jan 10, changed all PAUSes to INKEY$ for QDOS           *
124 rem + ************************************************************************ +
126 :
128 :
130 ch = FOPEN("con")
132 wsx% = 324: wsy% = 160
134 scx% = SCR_XLIM(#ch)
136 WINDOW#ch; wsx%, wsy%, (scx% - wsx%) / 2, 40
138 BORDER#ch; 2, 2,0,3
140 :
142 REPeat main
144 CLS#ch: CSIZE#ch; 1,0
146 txt$ = 'Dot Rename': c% = (wsx% - LEN(txt$) * 8) / 2
148 CURSOR#ch; c%, 2
150 PRINT#ch; txt$
152 CURSOR#ch; c%, 12
154 PRINT#ch; FILL$("-", LEN(txt$))
156 CSIZE#ch; 0, 0: INK#ch; 7
158 :
160 REPeat inp
162  AT#ch; 3, 0: CLS#ch; 3
164  Centre 'Convert dot or underscore', 30, 6
166  Centre '<. | _> ? ', 52, 6
168  CURSEN#ch: k$ = INKEY$(#ch; -1)
170  CURDIS#ch
172  IF k$ = CHR$(27): Bye 0
174  IF k$ INSTR '._': EXIT inp
176  BEEP 2000, 200
178 END REPeat inp
180 :
182 BEEP 2000, 2
184 IF k$ = '.' THEN
186  dot$ = '.': dash$ = '_'
188 ELSE
190  dot$ = '_': dash$ = '.'
192 END IF
194 INK#ch; 4
196 PRINT#ch; dot$
198 :
200 INK#ch; 7
202 PRINT#ch\\'Convert'! dot$! 'to'! dash$\\
204 :
206 Menu 1, 'Convert single file'
208 Menu 2, 'Convert directory'
210 Menu 3, 'Convert sub directories'
212 :
214 REPeat inp
216  k$ = INKEY$(#ch; -1)
218  k% = k$ INSTR '123' & CHR$(27)
220  IF k%: EXIT inp
222  BEEP 2000, 200
224 END REPeat inp
226 :
228 BEEP 2000, 2
230 INK#ch; 7: PRINT#ch
232 SELect ON k%
234  = 1: PRINT#ch; 'Enter full file name'
236       INK#ch; 4: INPUT#ch; fnm$
238  = 2: subd = 0
240       PRINT#ch; 'Enter directory to convert'
242       INK#ch; 4: INPUT#ch; fnm$
244  = 3: subd = 1
246       PRINT#ch; 'Enter top directory'
248       INK#ch; 4: INPUT#ch; fnm$
250  = 4: Bye 0
252 END SELect
254 IF fnm$ = '': Bye 0
256 :
258 er = ParseFnm(fnm$, dev$, dir$, name$, ext$)
260 IF er < 0: Bye er
262 SELect ON k%
264  = 1: IF LEN(dev$) THEN
266        IF LEN(name$) THEN
268         name$ = name$ & ext$
270         Convert fnm$
272        ELSE
274         Bye -8
276        END IF
278       END IF
280  = 2, 3: MConvert
282 END SELect
284 PRINT#ch\\ 'Done': k$ = INKEY$(#ch; 100)
286 END REPeat main
288 :
290 :
292 DEFine PROCedure Convert(fnm$)
294 LOCal l%, i%, ok, t$
296 l% = LEN(fnm$): IF l% < 3: RETurn
298 er = FTEST(fnm$)
300 IF er < 0 THEN
302  PRINT#ch; fnm$, er
304  RETurn
306 END IF
308 :
310 ok = 0: t$ = fnm$
312 FOR i% = l% TO l% - 5 STEP -1
314  IF fnm$(i%) = dot$: t$(i%) = dash$: ok = 1: EXIT i%
316 END FOR i%
318 IF ok THEN
320  IF FTEST(t$) = 0 THEN
322   PRINT#ch; 'Already exists!'
324  ELSE
326   RENAME fnm$, t$
328  END IF
330 END IF
332 END DEFine Convert
334 :
336 :
338 DEFine PROCedure MConvert
340 LOCal dl, fc, dt, nm$(42)
342 fc = NextFileInit(dev$, dir$, subd)
344 IF fc < 0: Bye fc
346 :
348 REPeat dl
350  er = NextFile(dev$, nm$, typ%)
352  IF er < 0: EXIT dl
354  IF typ% = 255: NEXT dl
356  PRINT#ch; 'Converting'! dev$; nm$
358  Convert dev$ & nm$
360 END REPeat dl
362 IF er THEN
364  IF er<> -10: Bye er
366 END IF
368 END DEFine MConvert
370 :
372 :
374 DEFine PROCedure Centre(tx$, y%, z%)
376 CURSOR#ch; (wsx% - LEN(tx$) * z%) / 2, y%
378 PRINT#ch; tx$;
380 END DEFine Centre
382 :
384 :
386 DEFine PROCedure Menu(n%, tx$)
388 INK#ch; 7: PRINT#ch; n%; '. ';
390 INK#ch; 4: PRINT#ch; tx$
392 END DEFine Menu
394 :
396 :
398 DEFine PROCedure Bye(ec)
400 INK#ch; 2
402 IF ec < 0
404  BEEP 2000, 200
406  REPORT#ch; ec
408 ELSE
410  Centre 'Bye!', wsy% - 20, 6
412  BEEP 2000, 2
414 END IF
416 k$ = INKEY$(#ch; 50)
418 STOP: QUIT ec
420 END DEFine Bye
422 :
424 :
426 rem + ------------------------------------------------------------------------ +
428 rem |<                              New ParseFnm                              >|
430 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
432 rem |               Splits a filename into its constituent parts               |
434 rem |                                                                          |
436 rem | The Device name must valid! (Or test that prior to calling this!)        |
438 rem | The directory must exist or it will be taken as part of file name!       |
440 rem | Everything else is optional.                                             |
442 rem | Extension (if any) is returned with leading separator                    |
444 rem | An extension is expected to be from 0 to 5 char long                     |
446 rem |                                                                          |
448 rem | No dependencies                                                          |
450 rem + ------------------------------------------------------------------------ +
452 rem | V0.01, pjw, 2023 Jun 12                                                  |
454 rem + ------------------------------------------------------------------------ +
456 :
458 DEFine FuNction ParseFnm(f$, r.v$, r.d$, r.n$, r.x$)
460 LOCal cd, i%, t%, l%
462 t% = LEN(f$): IF t% < 5: RETurn -15
464 :
466 rem         Device
468 IF f$(5) <> '_': RETurn -12
470 IF NOT f$(4) INSTR '12345678': RETurn -12
472 r.v$ = f$(1 TO 5): r.d$ = '': r.n$ = '': r.x$ = ''
474 IF t% = 5: RETurn 0
476 :
478 rem         Remainder
480 cd = FOP_DIR(f$): IF cd < 0: RETurn cd
482 r.d$ = FNAME$(#cd): CLOSE#cd
484 l% = LEN(r.d$) + 1
486 IF l% = 1 THEN
488  r.n$ = f$(6 TO t%)
490 ELSE
492  r.d$ = r.d$ & '_'
494  IF t% <= (l% + 5): RETurn 0
496  r.n$ = f$(l% + 6 TO t%)
498 END IF
500 :
502 rem         Extension
504 l% = LEN(r.n$)
506 IF l% > 6: t% = l% - 5: ELSE : t% = 2
508 FOR i% = l% TO t% STEP -1
510  r.x$ = r.n$(i%) & r.x$
512  IF r.n$(i%) INSTR '_.' THEN
514   r.n$ = r.n$(1 TO i% - 1)
516   RETurn 0
518  END IF
520 END FOR i%
522 r.x$ = '': RETurn 0
524 END DEFine ParseFnm
526 :
528 :
530 rem + ------------------------------------------------------------------------ +
532 rem |<                              NextFileInit                              >|
534 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
536 rem |                 Open and initialise directory structure                  |
538 rem |                                                                          |
540 rem | Parameters:                                                              |
542 rem |        dv$  = device name                                                |
544 rem |        dr$  = starting directory                                         |
546 rem |        subd = traverse = 1, or not = 0                                   |
548 rem |                                                                          |
550 rem | GLOBals:                                                                 |
552 rem |        nf_chan%() - Array of channel numbers                             |
554 rem |        nf_level%  - Current sub directory level                          |
556 rem |        nf_subdir  - Sub directory flag:                                  |
558 rem |                         0 => this dir only, 1 => sub dirs                |
560 rem + ------------------------------------------------------------------------ +
562 rem | V0.04, pjw, 2021 Oct 04                                                  |
564 rem + ------------------------------------------------------------------------ +
566 :
568 DEFine FuNction NextFileInit(dv$, dr$, subd)
570 LOCal ch
572 DIM nf_chan%(17): nf_level% = 0
574 ch = FOP_DIR(dv$ & dr$): IF ch < 0: RETurn ch
576 nf_chan%(nf_level%) = ch
578 nf_subdir = subd
580 RETurn 0
582 END DEFine NextFileInit
584 :
586 :
588 rem + ------------------------------------------------------------------------ +
590 rem |<                                NextFile                                >|
592 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
594 rem |                   Get Next file in a directory (tree)                    |
596 rem |                                                                          |
598 rem | Gets the next file on each call - as if it were a stream of files and    |
600 rem | directories                                                              |
602 rem |                                                                          |
604 rem | Parameters:                                                              |
606 rem |        dv$   = device name                                               |
608 rem |        dr$   = current directory. Updated!                               |
610 rem |        r.xxx = return parameters                                         |
612 rem |                                                                          |
614 rem | The r.xxx variables are just a selection of possible other file          |
616 rem | information that can be returned, depending on requirements of           |
618 rem | calling program.                                                         |
620 rem |                                                                          |
622 rem | Dependencies:                                                            |
624 rem | Must be initialised with NextFileInit, which sets certain GLOBal         |
626 rem | variables (see NextFileInit) and opens the first directory.              |
628 rem | CloseAll can be used to close all open sub directories should the need   |
630 rem | arise to abort before the whole directory tree has been exhaustively     |
632 rem | traversed.                                                               |
634 rem + ------------------------------------------------------------------------ +
636 rem | V0.04, pjw, 2021 Oct 04                                                  |
638 rem + ------------------------------------------------------------------------ +
640 :
642 DEFine FuNction NextFile(dv$, dr$, r.ftype%)
644 LOCal loop, l%, er, rec$(64)
646 er = 0:                                         rem Init error variable
648 REPeat loop
650  IF EOF(#nf_chan%(nf_level%)) THEN
652   CLOSE#nf_chan%(nf_level%)
654   nf_level% = nf_level% - 1:                    rem Up level
656   IF nf_level% < 0: er = -10: EXIT loop
658  ELSE
660   BGET#nf_chan%(nf_level%); rec$(1 TO 64):      rem Get file record
662   l% = CODE(rec$(16)): IF l% = 0: NEXT loop:    rem Name length
664   dr$ = rec$(17 TO l% + 16):                    rem Name
666   r.ftype% = CODE(rec$(6)):                     rem File type
668   IF r.ftype% = 255 THEN
670    IF nf_subdir THEN
672     er = FOP_DIR(dv$ & dr$ & '_'):              rem Next level
674     IF er < 0: EXIT loop
676     nf_level% = nf_level% + 1:                  rem Down level
678     nf_chan%(nf_level%) = er
680    END IF
682   ELSE
684   END IF
686   EXIT loop
688  END IF
690 END REPeat loop
692 RETurn er
694 END DEFine NextFile
696 :
698 :
700 rem + ------------------------------------------------------------------------ +
702 rem |<                                CloseAll                                >|
704 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
706 rem |      Close all open channels in the event NextFile was interrupted       |
708 rem |                                                                          |
710 rem + ------------------------------------------------------------------------ +
712 rem | V0.04, pjw, 2021 Oct 04                                                  |
714 rem + ------------------------------------------------------------------------ +
716 :
718 DEFine PROCedure CloseAll
720 LOCal cl
722 REPeat cl
724  IF nf_level% < 0: EXIT cl
726  CLOSE#nf_chan%(nf_level%)
728  nf_level% = nf_level% - 1
730 END REPeat cl
732 END DEFine CloseAll
734 :
736 :
