* S*Basic functions IOBFMUL & IOBFLIN
*
* V0.00 May 3rd 2002
* V0.01 Remove lf after flin
* V0.02 Fixed stack problem. Restored lf
* V0.03 Fix due to new info on qa.resri. New names
* V0.04 Better parameter checking. Split off common
* V0.05 Logical reordering. No functional change


        section code

        include dev8_keys_sbasic
        include dev8_keys_qdos_io
        include dev8_keys_err

        xdef IOBFLIN,IOBFMUL

        xref getpars,resrir,channel
        xref sputp_a1,io_ret


*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Simplified FSTRG$:
*
* Usage: er% = IOBFMUL%([#ch%;] timeout%, buflen%, str$)
*        er% = IOBFLIN%([#ch%;] timeout%, buflen%, str$)
*
*       where:  #ch% is the channel number to use (default #3)
*
*               timeout% [-1,0..32k] allow this many frames to complete
*
*               buflen% is the size of the string buffer
*
*               str$ contains the string to send to the channel.

* Note: LF is included in str$ in IOBFLIN%

IOBFLIN
        moveq #iob.flin,d5      flag fetch LF-terminated line
        bra.s fs_0

IOBFMUL
        moveq #iob.fmul,d5      flag fetch multiple bytes

fs_0
        bsr channel             get channel no (default #3)
        bne.s exit                (channel routine tidies its own stack)

        lea.l 3*8(a3),a4        three (more) parameters wanted
        cmpa.l a4,a5
        bne.s err_bp            wrong number of pars!

        move.l sb_arthp(a6),d7  save "empty" stack pointer
        sub.l sb_arthb(a6),d7   make it relative to BAS

        moveq #$20,d0           get two (more) integers
        bsr getpars
        bne.s exit

        cmpi.b #ar.strng,1(a6,a3.l) is last par a string string?
        bne.s err_bp

        move.w 0(a6,a1.l),d3    d3 = timeout
        move.w 2(a6,a1.l),d1    d1 = number of bytes to fetch (nbf)
        bmi.s err_bp

        addq.l #4,sb_arthp(a6)

        move.w d1,d2            this is where iow.fxxx wants it
        ext.l d1
        addq.l #2,d1            room for len
        bsr resrir              reserve room

        move.w d2,d1            any bytes to fetch?
        beq.s nul                is there justification for accepting this?

        move.l a1,a5            save offset to start
        addq.l #2,a1            leave room for len

        move.w d5,d0            use flin or fmul
        trap #do.relio          relative
        trap #do.io

stuffret
        movea.l a5,a1           point to start

nul
        move.w d1,0(a6,a1.l)    set len
        move.w d0,d6            save error

        bsr sputp_a1            stuff string into var str$
        bra io_ret

err_bp
        moveq #err.ipar,d0

exit
        rts

*
        end
