* S*Basic functions FMUL2MEMT & FLIN2MEMT
*
* V0.01, pjw, 2023 Jun 01, Based on the IOBFMUL/FLIN, but bytes sent to memory
* V0.01, pjw, 2023 Jul 11, tweaked to return bytes fetched or error

        section code

        include dev8_keys_sbasic
        include dev8_keys_qdos_io
        include dev8_keys_err

        xdef FLIN2MEMT,FMUL2MEMT

        xref getpars,channel

*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Usage: er% = FMUL2MEMT%([#ch%;] timeout%, bufflen%, addr)
*        er% = FLIN2MEMT%([#ch%;] timeout%, bufflen%, addr)
*
*       where:  #ch% is the channel number to use (default #3)
*
*               bufflen% is the size of the buffer
*                    must be a positive number between 0 and 32767
*
*               timeout% is time to wait for completion, -1, 0..32k
*
*               addr is the address where to load.
*                    must point to a buffer of at least bufflen
*                    must be an even, positive, none-zero address
*
* Note: The terminating LF is included in the buffer in IOBFLIN%

FLIN2MEMT
        moveq #iob.flin,d5      flag fetch LF-terminated line
        bra.s fs_0

FMUL2MEMT
        moveq #iob.fmul,d5      flag fetch multiple bytes

fs_0
        bsr channel             get channel no (default #3)
        bne.s exit

        lea.l 3*8(a3),a4        three (more) parameters wanted
        cmpa.l a4,a5
        bne.s err_bp            wrong number of pars!

        moveq #$20,d0           two short integers
        bsr getpars
        bne.s exit

        moveq #$16,d0           get one long integer
        bsr getpars
        bne.s exit

        move.l (a6,a1.l),d0    get address
        ble.s err_bp

        btst #0,d0              address must be even
        bne.s err_bp

        move.w 4(a6,a1.l),d3    timeout
        cmp.w #-1,d3            -1 is minimum
        blt.s err_bp


        move.w 6(a6,a1.l),d2    d2 = number of bytes to fetch (nbf)
        bmi.s err_bp

        addq.l #6,sb_arthp(a6)  leave room for int return

        move.l d0,a1            a1 -> buffer
        move.w d5,d0            use flin or fmul
        trap #do.io

        movea.l sb_arthp(a6),a1

        tst.l d0
        beq.s ret               if no error, return bytes fetched

        moveq #err.eof,d2
        cmp.l d0,d2
        bne.s err_ret            some other error than eof

        tst.w d1                eof error, but did we get some bytes?
        bne.s ret                yes, so show those

err_ret
        move.w d0,d1            no more bytes, so return err/eof

ret
        move.w d1,(a6,a1.l)
        moveq #ar.int,d4
        moveq #0,d0
        rts

err_bp
        moveq #err.ipar,d0

exit
        rts

*
        end
