100 rem $$chan=7
102 rem $$stak=800
104 rem $$asmb=win1_uti_key_Keyw_bin,0,10
106 rem $$heap=24000
108 :
110 rem     Runtime extensions
112 EXT_PROC 'OUTLSZ'
114 EXT_FN 'MN_MAIN', 'PEEKSTR$', 'EVEN', 'ODD', 'VALID%', 'DETAB$', 'OWNJOB'
116 :
118 rem + ------------------------------------------------------------------------ +
120 rem |<                                Keywords                                >|
122 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
124 rem |                 Scan a binary file for S*BASIC keywords                  |
126 rem |                                                                          |
128 rem | SMSQ/E-compatible, dont know about Qdos.                                 |
130 rem | Qlib_run, ptrmen_cde, bespoke toolkit                                    |
132 rem + ------------------------------------------------------------------------ +
134 rem | V0.17, pjw, 2023 Jun 25 - 2024 Nov 15                                    |
136 rem + ------------------------------------------------------------------------ +
138 :
140 rem     Config stuff
142 Config$="<<QCFX>>01 Keywords 0.17 H $         Set Home Directory                                   "
144 Config$=Config$(69 to 68+code(Config$(68)))
146 :
148 rem     Wman/Window stuff
150 sp_scrbar%      = 545: rem Pan/scroll bar
152 sp_scrbarsec%   = 546: rem Pan/scroll bar section
154 sp_scrbararr%   = 547: rem Pan/scroll bar arrow
156 sp_subtitbg%    = 563: rem Subtitle background
158 sp_subtittxtbg% = 564: rem Subtitle text background
160 sp_subtitfg%    = 565: rem Subtitle foreground
162 :
164 ww_nappl        = 110: rem .w  $6e  number of application sub-windows
166 ww_pappl        = 112: rem .l  $70  pointer to application sub-window definition list
168 wwa_nxsc        =  32: rem .w  $20  maximum number of x control sections
170 wwa_nysc        =  34: rem .w  $22  maximum number of y control sections
172 wwa_psac        =  64: rem .w  $40  pan or scroll arrow colour
174 wwa_psbc        =  66: rem .w  $42  pan or scroll bar colour
176 wwa_pssc        =  68: rem .w  $44  pan or scroll bar section colour
178 wwa_clen%       =  30: rem     $1e  - application sub-window control definition length
180 :
182 aw_title% =  1:         rem Application subwindow numbers
184 aw_main%  =  2
186 li_quit%  = -1:         rem ESC         - quit
188 li_prt%   = -2:         rem CTR + p     - print
190 li_resz%  = -3:         rem CTR + F3    _ resize
192 :
194 wsx% = 210: wsy% = 206
196 mencon = 2^16
198 dim pr%(15)
200 :
202 rem $$off
204 if peek$(\\-4, 4) = 'SBAS' then
206  job_name 'Keywords bas'
208  lrespr home_dir$ & 'Keyw_bin'
210 endif
212 rem $$on
214 :
216 rem     Get config and set defaults
218 if Config$ = '' then
220  root$ = home_dir$
222 else
224  root$ = Config$: AddUnder root$
226 endif
228 cfg$ = 'keyw_cfg'
230 ert GetConfig
232 :
234 rem FSEL basic command line
236 fnm = alchp(44):       rem FSEL return address
238 rem cml$ = ' /W500 /H400 /P1 /T"Enter Toolkit" /F- /R' & hex$(fnm, 32)
240 cml$ = ' /T"Enter Toolkit" /F- /R' & hex$(fnm, 32)
242 cml$ = cml$ & ' /W' & wid% & ' /H' & hite% & ' /P' & palette
244 :
246 rem     Init GLOBal variables
248 rem     Sanity check:
250 mxkey% = 1400:          rem Max no. keywords
252 mxkwl% =   24:          rem Max keyword length
254 :
256 dim Names$(mxkey%, mxkwl%)
258 Names$(0) = ''
260 :
262 rem     Legal name chars (SMSQ/E) Exclusive only. INSTR translates upper
264 namechrs$ = '$'
266 for i% = 37,46,48 to 57,65 to 90,95,140 to 156,160 to 178
268  namechrs$ = namechrs$ & chr$(i%)
270 endfor i%
272 rem     End GLOBal variables
274 :
276 sp_jobpal -1, palette
278 :
280 :
282 rem     Start
284 fnm$ = CMD$: cmd = len(fnm$)
286 :
288 fixed = 1
290 cw = fopen("con")
292 wox% = -1: woy% = wox%
294 Redraw 'Keywords'
296 :
298 rep main
300  if cmd then
302   cmd = 0
304  else
306   fnm$ = GetFile$(#cw; fnm, '/D' & dir$ & '/E ' & ext$ & ' /X' & (wox% + 10) & ' /Y' & (woy% + 20) & cml$)
308  endif
310  :
312  if len(fnm$) < 6: Bye -12: else: dev$ = fnm$(1 to 5)
314  cd = fop_dir(fnm$): if cd < 0: Bye cd
316  dir$ = dev$ & fname$(#cd): AddUnder dir$
318  close#cd
320  ext$ = '_' & GetExt$(fnm$)
322  :
324  er = KeyImport(fnm$)
326  if er = 0: er = -7
328  if er < 0: report_error er, (wsx% - 200) / 2, 30: next main
330  :
332  dim Dis$(found%, 30), under%(found%)
334  for i% = 1 to found%
336   under%(i%) = 1
338   l% = len(Names$(i%))
340   prc$ = Names$(i%, l%): l% = l% - 1
342   k% = code(Names$(i%, l%))
344   d$ = Names$(i%, 1 to l%) & fill$(" ", 25 - l%)
346   d$ = d$ & prc$ & '-'
348   sel on k%
350    = 36: d$ = d$ & 'str'
352    = 37: d$ = d$ & 'int'
354    = remainder: d$ = d$ & 'flt'
356   endsel
358   Dis$(i%) = d$
360  endfor i%
362  again$ = 'Found ' & found%
364  Dis$(0) = fill$(' ', (30 - len(again$)) / 2) & again$
366  if fixed then
368   Title fnm$
370   MAWdrw
372  else
374   Resize 2
376  endif
378  :
380  rep lp
382   k = mcall(#cw, k, st%): pval#cw; pr%
384   sel on k
386    = li_quit%: Bye 0
388    = li_prt%: OutPut
390    = li_resz%: k% = pr%(5)
392      sel on k%: = 1, 2: Resize k%
394    =  aw_title%
396       if pr%(5) = 1 then
398        wmov#cw; -1
400        OUTLSZ#cw; x%, wsy%, wox%, woy%
402        next lp
404       endif
406       if pr%(5) = 2: Bye 0
408    = mencon to 1e9
410      k% = k / mencon
412      if k% = 1: exit lp
414   endsel
416  endrep lp
418 endrep main
420 :
422 :
424 def proc Bye(er)
426 quit er
428 enddef Bye
430 :
432 :
434 rem + ------------------------------------------------------------------------ +
436 rem |<                            Window routines                             >|
438 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
440 rem |                                                                          |
442 rem |                                                                          |
444 rem | Redraw, Resize, MAWdrw (setting arrow/bar colours), Title                |
446 rem + ------------------------------------------------------------------------ +
448 rem | V0.01, pjw, 2019 Jul 20+                                                 |
450 rem + ------------------------------------------------------------------------ +
452 :
454 rem + ------------------------------------------------------------------------ +
456 rem |<                                 Resize                                 >|
458 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
460 rem |                        Resize using top left icon                        |
462 rem |                                                                          |
464 rem | HIT and drag icon to desired position, or DO icon for optimal size       |
466 rem | HIT resets scaling flag scale%                                           |
468 rem + ------------------------------------------------------------------------ +
470 :
472 def proc Resize(s%)
474 loc x%, y%
476 if s% = 2 then
478  wsy% = found% * 11 + 34
480  fixed = 0
482 else
484  wsize#cw; x%, y%
486  wsy% = wsy% - y%
488  woy% = woy% + y%
490  fixed = 1
492 endif
494 :
496 mclear#cw: Redraw fnm$
498 MAWdrw
500 enddef Resize
502 :
504 def proc Redraw(tit$)
506 mdraw#cw; MN_MAIN, wox%, woy%, wsx%, wsy%
508 Title tit$
510 OUTLSZ#cw; x%, wsy%, wox%, woy%
512 enddef Redraw
514 :
516 def proc MAWdrw
518 mawsetup#cw; aw_main%, Dis$, 0, 0, under%
520 SetScroll#cw; aw_main%
522 mawdraw#cw; aw_main%
524 enddef MAWdrw
526 :
528 :
530 def proc Title(t$)
532 l% = len(t$) * 6
534 mwindow#cw\ aw_title%
536 wm_block#cw; wsx% - 24, 14, 0, 0, sp_subtitbg%
538 wm_block#cw; l% + 4, 11, (wsx% - l% - 24) / 2 , 3, sp_subtittxtbg%
540 wm_ink#cw; sp_subtitfg%: cursor#cw; (wsx% - l% - 20) / 2, 4: bput#cw; t$
542 enddef Title
544 :
546 :
548 rem + ------------------------------------------------------------------------ +
550 rem |<                             Output to File                             >|
552 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
554 rem |                    Simple, incremental print to file                     |
556 rem |                                                                          |
558 rem | Increments name from 0 to max 9, then gives up with a burp               |
560 rem + ------------------------------------------------------------------------ +
562 rem | V0.01, pjw, 2019                                                         |
564 rem + ------------------------------------------------------------------------ +
566 :
568 def proc OutPut
570 loc i%, nm$(38), xt$(4)
572 xt$ = '_' & GetExt$(out$)
574 nm$ = out$(1 to len(out$) - len(xt$))
576 er = SaveKeys(nm$ & xt$)
578 for i% = 0 to 9
580  if er = 0 or er <> -8: beep 2000, 2: ret
582  er = SaveKeys(nm$ & i% & xt$)
584 endfor i%
586 if er < 0: beep 2000, 200
588 enddef OutPut
590 :
592 def fn SaveKeys(ofn$)
594 loc ch
596 if len(ofn$) > 41: ret -12
598 ch = fop_in(ofn$)
600 if ch >= 0: close#ch: ret -8
602 if ch <> -7: return ch:         rem SMSQ 3.34 returns -7 on len(fnm$) > 41
604 :
606 ch = fop_over(ofn$)
608 bput#ch; fnm$, 10
610 print#ch; Dis$
612 close#ch
614 ret 0
616 enddef SaveKeys
618 :
620 :
622 rem + ------------------------------------------------------------------------ +
624 rem |<                           Scan for Keywords                            >|
626 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
628 rem |                    Extract keywords from binary file                     |
630 rem |                                                                          |
632 rem | KeyImport - loads binary file                                            |
634 rem | Key       - test-extracts a single keyword                               |
636 rem | Keywords  - adds extracted keyword to a list                             |
638 rem | Pkeys     - subroutine of Keywords; does the actual work                 |
640 rem |                                                                          |
642 rem | GLOBal variables: found%, Names$(), mxkey%, mxkwl%, namechrs$            |
644 rem + ------------------------------------------------------------------------ +
646 rem | V0.01, P Witte May 1995                                                 |
648 rem | V0.10, pjw, 2oi5, No screen output; all to arrays                        |
650 rem | V0.11, pjw, 2019 Jul 27, replaced most home extensions                   |
652 rem | V0.12, pjw, 2023 Jun 20, partial rewrite, and tightening of code         |
654 rem + ------------------------------------------------------------------------ +
656 :
658 def fn KeyImport(fnm$)
660 loc i%, i, ch, sz, adr, madr
662 :
664 ch = fop_in(fnm$): if ch < 0: ret ch
666 sz = FLEN(#ch): close#ch
668 madr = ALCHP(sz): IF madr <= 0: ret -3
670 lbytes fnm$, madr
672 :
674 found% = 0
676 FOR i = madr TO madr + sz - 2 STEP 2
678  IF PEEK_W(i) = 17402 then
680   REMark lea adr,a1
682   adr = peek_w(i + 2)
684   if adr = 0: next i: exit i
686   if ODD(adr): next i: exit i
688   adr = adr + i + 2
690   if Key(adr): Keywords adr
692  END IF
694 END FOR i
696 :
698 RECHP madr
700 ret found%
702 END def KeyImport
704 :
706 :
708 DEFine FuNction Key(ad)
710 LOCal j, a, np, l%, c$(1)
712 a = ad
714 np = PEEK_W(a)
716 IF np < 0 OR np > mxkey%: RETurn 0
718 if np = 0 then
720  rem No Procs. FNs?
722  a = a + 4
724  np = PEEK_W(a)
726  IF np < 0 OR np > mxkey%: RETurn 0
728 END IF
730 a = a + 4:      REMark pass first offset
732 l% = PEEK(a): IF l% = 0 or l% > mxkwl%: RETurn 0: rem Not a name
734 :
736 ret SCanKey
738 END DEFine Key
740 :
742 :
744 def proc Keywords(ad)
746 loc a, j, k, prc$(1)
748 loc l%, f%, t%, n%, c$(1), n$(mxkwl%)
750 :
752 rem     First do procedures
754 IF PEEK_W(ad) > 0 then
756  prc$ = 'P'
758  a = Pkeys(ad + 2)
760 ELSE
762  a = ad + 4
764 END IF
766 :
768 rem     Do Functions
770 IF PEEK_W(a) > 0 THEN
772  prc$ = 'F'
774  a = Pkeys(a + 2)
776 END IF
778 enddef Keywords
780 :
782 :
784 rem + ------------------------------------------------------------------------ +
786 rem |<                                 Pkeys                                  >|
788 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
790 rem |                              Parse Keywords                              |
792 rem |                                                                          |
794 rem | Rewrite to work around Qlib bug that causes program to hang under        |
796 rem | certain circumstances! (I hope!)                                         |
798 rem + ------------------------------------------------------------------------ +
800 rem | V0.18, pjw, 2025 Oct 14                                                  |
802 rem + ------------------------------------------------------------------------ +
804 :
806 DEFine FuNction Pkeys(ad)
808 loc kl, lp
810 a = ad
812 rep kl
814  if peek_w(a) = 0: ret a + 2
816  a = a + 2: l% = peek(a)
818  if l% <= mxkwl% and l% > 1 then
820   if ScanKey then
822    rem Only unique keywords wanted..
824    n$ = n$ & prc$:              rem Encode type into name
826    n% = BSearch%(n$, Names$)
828    if n% < 0: Insert n$, Names$, ABS(n%)
830   endif
832  endif
834  a = EVEN(a + l% + 1)
836 endrep kl
838 ret a + 2
840 enddef Pkeys
842 :
844 :
846 rem + ------------------------------------------------------------------------ +
848 rem |<                                ScanKey                                 >|
850 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
852 rem |                    Sub routine. Uses caller's LOCals                     |
854 rem + ------------------------------------------------------------------------ +
856 rem | V0.01, pjw, 2025 Oct 14                                                  |
858 rem + ------------------------------------------------------------------------ +
860 :
862 deffn ScanKey
864 n$ = ''
866 j = a + 1: k = j + l%
868 rep lp
870  c$ = chr$(peek(j))
872  if not c$ instr namechrs$: ret 0
874  n$ = n$ & c$
876  j = j + 1: if j >= k: ret 1
878 endrep lp
880 end def ScanKey
882 :
884 :
886 rem + ------------------------------------------------------------------------ +
888 rem |<                                Get File                                >|
890 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
892 rem |                             Wrapper for FSEL                             |
894 rem |                                                                          |
896 rem + ------------------------------------------------------------------------ +
898 rem | V0.01, pjw, originally ExExt                                             |
900 rem | V0.04, pjw, 16 Dec 2016                                                  |
902 rem | V0.06, pjw, 2019 Jul 27, re-write for FSEL 0.06                          |
904 rem + ------------------------------------------------------------------------ +
906 :
908 def fn GetFile$(ch, fnmaddr, cl$)
910 loc x%, y%, fnm$(42)
912 loc hl, id, nj, tv%
914 :
916 fnm$ = PEEKSTR$(fnmaddr)
918 :
920 rem EX job, owned by me (If I die, so does FSEL)
922 if fsel$ = '-' then
924  id = fep("FSEL"; cl$)
926  ert OWNJOB(id, -1)
928 else
930  id = FEX_M(fsel$; cl$)
932 endif
934 if len(job$(id)) = 0: ret '': rem FSEL ERRored; code in addr
936 :
938 tv% = 6
940 rep hl
942  rdpt#ch; tv%
944  if len(job$(id)) = 0: exit hl: rem Selection done; FSEL terminated
946                                 rem A little finesse here
948  nj = nxjob(id, 0)
950                                 rem If FSEL asleep..
952  if asleep$ instr job$(nj) then
954   if tv% div 256 then
956    rjob nj, 0: beep 2000,2:     rem If a key pressed, WAKE
958   else
960    next hl:                     rem Otherwise ignore
962   endif
964  endif
966  ptop#ch; id:                   rem Always pick FSEL on top unltil done
968 endrep hl
970 ptop#ch; jobid:                 rem Done! Now me on top!
972 :
974 ret PEEKSTR$(fnmaddr):          rem Return file name (or, rarely, error)
976 END DEFine GetFile$
978 :
980 :
982 rem + ------------------------------------------------------------------------ +
984 rem |<                             Get Extension                              >|
986 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
988 rem | Extract the extension from a filename                                    |
990 rem | Not 100% foolproof! Extension length betw 1 and 4 char                   |
992 rem | Separator . or _  (is not included in return)                            |
994 rem | If it doesnt like what it sees, or there is no ext, returns ''           |
996 rem + ------------------------------------------------------------------------ +
998 rem | V0.01, pjw, mists of time..                                              |
1000 rem | V0.03, pjw, February 11th 2018                                           |
1002 rem + ------------------------------------------------------------------------ +
1004 :
1006 DEFine FuNction GetExt$(fnm$)
1008 LOCal i%, l%
1010 l% = LEN(fnm$)
1012 IF l% >= 3 THEN
1014  FOR i% = l% TO l% - 4 STEP -1
1016   IF fnm$(i%) INSTR '_.': RETurn fnm$(i% + 1 TO l%)
1018  END FOR i%
1020 END IF
1022 RETurn ''
1024 END DEFine GetExt$
1026 :
1028 :
1030 rem + ------------------------------------------------------------------------ +
1032 rem |<                                BSearch                                 >|
1034 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1036 rem |                              Binary Search                               |
1038 rem |                                                                          |
1040 rem | Returns position if found, or -position where item should go. Thus it    |
1042 rem | can be used to add new, unique items to a list, in alphabetical order.   |
1044 rem |                                                                          |
1046 rem | Arrays indexed from 1..                                                  |
1048 rem | Designed for numeric data but can be used for CASE-dependent strings     |
1050 rem + ------------------------------------------------------------------------ +
1052 rem | V0.01, pjw, 1996+, From TAOCP 6.2.1                                      |
1054 rem | V0.02, pjw, 2021 Jun 30, Numeric version; integers and floats            |
1056 rem | V0.02, pjw, 2023 Jun 20, Modyfied for KeyScanner                         |
1058 rem + ------------------------------------------------------------------------ +
1060 :
1062 DEFine FuNction BSearch%(item, Arr)
1064 LOCal loop, u%, l%, i%
1066 l% = 0: u% = found%
1068 REPeat loop
1070  IF u% < l%: i% = -l%: EXIT loop:               rem Not found here
1072  i% = INT((l% + u%) / 2)
1074  IF item = Arr(i%): EXIT loop
1076  IF item < Arr(i%) THEN
1078   u% = i% - 1
1080  ELSE
1082   l% = i% + 1
1084  END IF
1086 END REPeat loop
1088 RETurn i%
1090 END DEFine BSearch%
1092 :
1094 :
1096 rem + ------------------------------------------------------------------------ +
1098 rem |<                                 Insert                                 >|
1100 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1102 rem |            Insert item in an array at given position, 0..DIMN            |
1104 rem |                                                                          |
1106 rem | Item and array can be of any type                                        |
1108 rem |                                                                          |
1110 rem | GLOBal found%                                                            |
1112 rem + ------------------------------------------------------------------------ +
1114 rem | V0.01, pjw, 2017 Mar                                                     |
1116 rem | V0.02, pjw, 2021 Jun 30, Simplified                                      |
1118 rem | V0.02, pjw, 2023 Jun 20, Modyfied for KeyScanner                         |
1120 rem + ------------------------------------------------------------------------ +
1122 :
1124 DEFine PROCedure Insert(item, Arr, at%)
1126 LOCal i%
1128 found% = found% + 1
1130 IF at% < found% THEN
1132  FOR i% = found% TO at% + 1 STEP -1
1134   Arr(i%) = Arr(i% - 1)
1136  END FOR i%
1138 END IF
1140 Arr(at%) = item
1142 END DEFine Insert
1144 :
1146 :
1148 rem + ------------------------------------------------------------------------ +
1150 rem |<                              Set Arrow/Bar                             >|
1152 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1154 rem |           Set AW arrow and bar colours, omitted by EasyPointer           |
1156 rem |                                                                          |
1158 rem + ------------------------------------------------------------------------ +
1160 rem | V0.00, Bob Spelten                                                       |
1162 rem | V0.01, pjw, November 7th 2017                                            |
1164 rem | V0.02, pjw, 2019 Jul 29, re-write. Still not working :o(                 |
1166 rem + ------------------------------------------------------------------------ +
1168 :
1170 def proc SetScroll(ch, aw%)
1172 loc wwd, awl, awa, csy
1174 wwd = mwdef(#ch)
1176 awl = peek_l(wwd + ww_pappl):            rem Get AW list
1178 :
1180 if peek_w(wwd + ww_nappl) < aw%: return: rem None or too few
1182 awa = peek_l(awl + (aw% - 1) * 4):       rem awa -> to aw%
1184 :
1186 if peek_w(awa + wwa_nysc) = 0: return:   rem No y-control section
1188 csy =  awa + wwa_clen%:                  rem csy -> the one we want
1190 poke_w csy + wwa_psac, sp_scrbararr%:    rem scroll arrow colour
1192 poke_w csy + wwa_psbc, sp_scrbar%:       rem scroll bar colour
1194 poke_w csy + wwa_pssc, sp_scrbarsec%:    rem scroll section colour
1196 enddef SetScroll
1198 :
1200 :
1202 rem + ------------------------------------------------------------------------ +
1204 rem |<                               GetConfig                                >|
1206 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1208 rem |                Standard, configurable config file reader                 |
1210 rem |                                                                          |
1212 rem + ------------------------------------------------------------------------ +
1214 rem | V0.05, pjw, 2017 Jun                                                     |
1216 rem | V0.06, pjw, 2019 Jul 29, Keywords-specific                               |
1218 rem + ------------------------------------------------------------------------ +
1220 :
1222 def fn GetConfig
1224 loc ch, er, p%, lp, l$, t$, pl$
1226 :
1228 ch = CheckID(root$ & cfg$, 'KWCF01', 0)
1230 if ch < 0: ret ch
1232 :
1234 fsel$   =     '':       rem File selector
1236 out$    =     '':       rem Output file
1238 dir$    =     '':       rem Default start directory
1240 ext$    = '_bin':       rem Default extension
1242 wid%    =    500:       rem FSEL width
1244 hite%   =    400:       rem FSEL height
1246 palette =      0:       rem Default palette
1248 asleep$ = ' asleep':    rem Asleep job name in English
1250 :
1252 rep lp
1254  if eof(#ch): exit lp
1256  input#ch; l$
1258  if len(l$) = 0: next lp
1260  if l$(1) = '*': next lp
1262  t$ = GtCfgIt$("fsel "):    if len(t$)    :   fsel$   = t$: next lp
1264  t$ = GtCfgIt$("defd "):    if len(t$)    :   dir$    = t$: next lp
1266  t$ = GtCfgIt$("outf "):    if len(t$)    :   out$    = t$: next lp
1268  t$ = GtCfgIt$("width "):   if VALID%(3, t$): wid%    = t$: next lp
1270  t$ = GtCfgIt$("hight "):   if VALID%(3, t$): hite%   = t$: next lp
1272  t$ = GtCfgIt$("palette "): if VALID%(3, t$): palette = t$: next lp
1274  t$ = GtCfgIt$("asleep "):  if len(t$): asleep$  = ' ' & t$: next lp
1276 endrep lp
1278 close#ch
1280 :
1282 if fsel$ <> '-' then
1284  if fsel$ = '*': fsel$ = root$
1286  fsel$ = fsel$ & 'FSEL_obj'
1288  er = ftest(fsel$): if er: ret er
1290 endif
1292 :
1294 if len(dir$) < 5: ret -12
1296 dev$ = dir$(1 to 5)
1298 ch = fop_dir(dir$): if ch < 0: ret ch
1300 dir$ = dev$ & fname$(#ch): close#ch
1302 AddUnder dir$
1304 :
1306 if len(out$) < 8: ret -12
1308 t$ = GetExt$(out$)
1310 if len(t$) = 0: out$ = out$ & '_txt'
1312 :
1314 ret 0
1316 enddef GetConfig
1318 :
1320 rem + ------------------------------------------------------------------------ +
1322 rem |<                                GtCfgIt$                                >|
1324 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1326 rem | Get single Config Item (Subroutine of GetConfig)                         |
1328 rem + ------------------------------------------------------------------------ +
1330 :
1332 def fn GtCfgIt$(it$)
1334 if (it$ instr l$) <> 1: ret ''
1336 p% = '=' instr l$
1338 if p% = 0: ret ''
1340 t$ = DETAB$(l$(p% + 1 to len(l$)))
1342 for p% = 1 to len(t$)
1344  if t$(p%) = ' ': p% = p% - 1: exit p%
1346 endfor p%
1348 ret t$(1 to p%)
1350 enddef GtCfgIt$
1352 :
1354 :
1356 rem + ------------------------------------------------------------------------ +
1358 rem |<                                CheckID                                 >|
1360 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1362 rem | Open an IDed file and check for correct ID                               |
1364 rem |                                                                          |
1366 rem | If ok, return its open channel, with file pointer just past ID           |
1368 rem | io parameter: 0 = read only, 1 => read/write                             |
1370 rem + ------------------------------------------------------------------------ +
1372 :
1374 def fn CheckID(fnm$, id$, io)
1376 loc ch, p%, c$
1378 if io then
1380  ch = fopen(fnm$)
1382 else
1384  ch = fop_in(fnm$)
1386 endif
1388 if ch < 0: ret ch
1390 for p% = 1 to len(id$)
1392  c$ = inkey$(#ch; 50)
1394  if eof(#ch) or len(c$) = 0 or c$ <> id$(p%) then
1396   close#ch: ret -12: rem Not our config file
1398  endif
1400 endfor p%
1402 ret ch
1404 enddef CheckID
1406 :
1408 :
1410 rem + ------------------------------------------------------------------------ +
1412 rem |<                                AddUnder                                >|
1414 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1416 rem |                   Add directory underscore, if needed                    |
1418 rem |                                                                          |
1420 rem + ------------------------------------------------------------------------ +
1422 :
1424 def proc AddUnder(r.drv$)
1426 if r.drv$(len(r.drv$)) <> '_': r.drv$ = r.drv$ & '_'
1428 enddef AddUnder
1430 :
1432 :
