100 rem $$chan=7
102 rem $$stak=800
104 rem $$asmb=win1_uti_key_Keyw_bin,0,10
106 rem $$heap=24000
108 :
110 rem     Runtime extensions
112 EXT_PROC 'OUTLSZ'
114 EXT_FN 'MN_MAIN', 'PEEKSTR$', 'EVEN', 'ODD', 'VALID%', 'DETAB$'
116 EXT_PROC 'RPT%'
118 :
120 rem + ------------------------------------------------------------------------ +
122 rem |<                                Keywords                                >|
124 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
126 rem |                 Scan a binary file for S*BASIC keywords                  |
128 rem |                                                                          |
130 rem | Needs SMSQ/E V3.39+ as uses FEP_M etc                                    |
132 rem | This version is not compatible with Qdos/Minerva!                        |
134 rem | Qlib_run, ptrmen_cde, bespoke toolkit                                    |
136 rem |                                                                          |
138 rem | Note: This version requires updated config file! The old one wont work!  |
140 rem + ------------------------------------------------------------------------ +
142 rem | V0.18, pjw, 2023 Jun 25 - 2024 Nov 15                                    |
144 rem | V0.19, pjw, 2025 Dec 26, Update and many changes. No new functionality   |
146 rem + ------------------------------------------------------------------------ +
148 :
150 rem     Config stuff
152 Config$="<<QCFX>>01 Keywords 0.19 H $         Set Home Directory                                   "
154 Config$=Config$(69 to 68+code(Config$(68)))
156 :
158 rem     Wman/Window stuff
160 sp_scrbar%      = 545: rem Pan/scroll bar
162 sp_scrbarsec%   = 546: rem Pan/scroll bar section
164 sp_scrbararr%   = 547: rem Pan/scroll bar arrow
166 sp_subtitbg%    = 563: rem Subtitle background
168 sp_subtittxtbg% = 564: rem Subtitle text background
170 sp_subtitfg%    = 565: rem Subtitle foreground
172 :
174 ww_nappl        = 110: rem .w  $6e  number of application sub-windows
176 ww_pappl        = 112: rem .l  $70  pointer to application sub-window definition list
178 wwa_nxsc        =  32: rem .w  $20  maximum number of x control sections
180 wwa_nysc        =  34: rem .w  $22  maximum number of y control sections
182 wwa_psac        =  64: rem .w  $40  pan or scroll arrow colour
184 wwa_psbc        =  66: rem .w  $42  pan or scroll bar colour
186 wwa_pssc        =  68: rem .w  $44  pan or scroll bar section colour
188 wwa_clen%       =  30: rem     $1e  - application sub-window control definition length
190 :
192 aw_title% =  1:         rem Application subwindow numbers
194 aw_main%  =  2
196 li_quit%  = -1:         rem ESC         - quit
198 li_prt%   = -2:         rem CTR + p     - print
200 li_resz%  = -3:         rem CTR + F3    _ resize
202 :
204 fnmlen% = 24:           rem Max/min filename langth (est)
206 wsx%    = 210: wsy% = 250
208 mencon  = 2^16
210 dim pr%(15)
212 :
214 rem     ExExt
216 x_tv%  =  33:           rem Termination vector
218 x_je%  =   1:           rem Job event
220 x_tio% =  10:           rem Timeout
222 :
224 rem $$off
226 if peek$(\\-4, 4) = 'SBAS' then
228  job_name 'Keywords bas'
230  lrespr home_dir$ & 'Keyw_bin'
232 endif
234 rem $$on
236 :
238 rem     Get config and set defaults
240 if Config$ = '' then
242  root$ = home_dir$
244 else
246  root$ = Config$: AddUnder root$
248 endif
250 cfg$ = 'keyw_cfg'
252 ert GetConfig
254 :
256 rem FSEL basic command line
258 fnmadr = alchp(44):     rem FSEL return address
260 rem cml$ = ' /W500 /H400 /P1 /T"Enter Toolkit" /F- /R' & hex$(fnmadr, 32)
262 cml$ = ' /T"Enter Toolkit" /F- /R' & hex$(fnmadr, 32)
264 cml$ = cml$ & ' /W' & fwid% & ' /H' & hite% & ' /P' & palette
266 :
268 rem     Init GLOBal variables
270 rem     Sanity check:
272 mxkey% = 1400:          rem Max no. keywords
274 mxkwl% =   24:          rem Max keyword length
276 :
278 dim Names$(mxkey%, mxkwl%)
280 Names$(0) = ''
282 :
284 rem     Legal name chars (SMSQ/E) Exclusive only. INSTR translates upper
286 namechrs$ = '$'
288 for i% = 37,46,48 to 57,65 to 90,95,140 to 156,160 to 178
290  namechrs$ = namechrs$ & chr$(i%)
292 endfor i%
294 rem     End GLOBal variables
296 :
298 sp_jobpal -1, palette
300 :
302 :
304 rem     Start
306 fnm$ = CMD$: cmd = len(fnm$)
308 :
310 fixed = 1
312 cw = fopen("con")
314 wox% = -1: woy% = wox%
316 Redraw 'Keywords'
318 :
320 rep main
322  if cmd then
324   cmd = 0
326  else
328   fnm$ = GetFile$(#cw; fnmadr, '/D' & dir$ & '/E ' & ext$ & ' /X' & (wox% + 10) & ' /Y' & (woy% + 20) & cml$)
330  endif
332  :
334  fnmlen% = len(fnm$)
336  if fnmlen% < 6: Bye -12: else: dev$ = fnm$(1 to 5)
338  maxwid% = fnmlen% + 4: if maxwid% < 24: maxwid% = 24
340  wsx% = maxwid% * 6 + 32: wsy% = 206
342  mclear#cw: Redraw fnm$
344  :
346  cd = fop_dir(fnm$): if cd < 0: Bye cd
348  dir$ = dev$ & fname$(#cd): AddUnder dir$
350  close#cd
352  ext$ = '_' & GetExt$(fnm$)
354  :
356  er = KeyImport(fnm$)
358  dim Dis$(found%, maxwid%), under%(found%)
360  for i% = 1 to found%
362   under%(i%) = 1
364   l% = len(Names$(i%))
366   prc$ = Names$(i%, l%): l% = l% - 1:   rem F or P
368   k% = code(Names$(i%, l%)):            rem Type
370   d$ = Names$(i%, 1 to l%) & fill$(" ", maxwid% - l% - 4)
372   d$ = d$ & prc$ & '-'
374   sel on k%
376    = 36: d$ = d$ & 'str'
378    = 37: d$ = d$ & 'int'
380    = remainder: d$ = d$ & 'flt'
382   endsel
384   Dis$(i%) = d$
386  endfor i%
388  if er < 0 then
390   again$ = 'Error ' & er
392  else
394   again$ = 'Found ' & found%
396  endif
398  Dis$(0) = fill$(' ', (maxwid% - len(again$)) / 2) & again$
400  if fixed then
402   Title fnm$
404   MAWdrw
406  else
408   Resize 2
410  endif
412  :
414  rep lp
416   k = mcall(#cw, k, st%): pval#cw; pr%
418   sel on k
420    = li_quit%: Bye 0
422    = li_prt%: OutPut
424    = li_resz%: k% = pr%(5)
426      sel on k%: = 1, 2: Resize k%
428    =  aw_title%
430       if pr%(5) = 1 then
432        wmov#cw; -1
434        OUTLSZ#cw; x%, wsy%, wox%, woy%
436        next lp
438       endif
440       if pr%(5) = 2: Bye 0
442    = mencon to 1e9
444      k% = k / mencon
446      if k% = 1: exit lp
448   endsel
450  endrep lp
452 endrep main
454 :
456 :
458 def proc Bye(er)
460 quit er
462 enddef Bye
464 :
466 :
468 rem + ------------------------------------------------------------------------ +
470 rem |<                            Window routines                             >|
472 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
474 rem |                                                                          |
476 rem |                                                                          |
478 rem | Redraw, Resize, MAWdrw (setting arrow/bar colours), Title                |
480 rem + ------------------------------------------------------------------------ +
482 rem | V0.01, pjw, 2019 Jul 20+                                                 |
484 rem + ------------------------------------------------------------------------ +
486 :
488 rem + ------------------------------------------------------------------------ +
490 rem |<                                 Resize                                 >|
492 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
494 rem |                        Resize using top left icon                        |
496 rem |                                                                          |
498 rem | HIT and drag icon to desired position, or DO icon for optimal size       |
500 rem | HIT resets scaling flag scale%                                           |
502 rem + ------------------------------------------------------------------------ +
504 :
506 def proc Resize(s%)
508 loc x%, y%
510 if s% = 2 then
512  wsy% = found% * 11 + 34
514  fixed = 0
516 else
518  wsize#cw; x%, y%
520  wsy% = wsy% - y%
522  woy% = woy% + y%
524  fixed = 1
526 endif
528 :
530 mclear#cw: Redraw fnm$
532 MAWdrw
534 enddef Resize
536 :
538 def proc Redraw(tit$)
540 mdraw#cw; MN_MAIN, wox%, woy%, wsx%, wsy%
542 Title tit$
544 OUTLSZ#cw; x%, wsy%, wox%, woy%
546 enddef Redraw
548 :
550 def proc MAWdrw
552 mawsetup#cw; aw_main%, Dis$, 0, 0, under%
554 SetScroll#cw; aw_main%
556 mawdraw#cw; aw_main%
558 enddef MAWdrw
560 :
562 :
564 def proc Title(t$)
566 l% = len(t$) * 6
568 mwindow#cw\ aw_title%
570 wm_block#cw; wsx% - 24, 14, 0, 0, sp_subtitbg%
572 wm_block#cw; l% + 4, 11, (wsx% - l% - 24) / 2 , 3, sp_subtittxtbg%
574 wm_ink#cw; sp_subtitfg%: cursor#cw; (wsx% - l% - 20) / 2, 4: bput#cw; t$
576 enddef Title
578 :
580 :
582 rem + ------------------------------------------------------------------------ +
584 rem |<                             Output to File                             >|
586 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
588 rem |                    Simple, incremental print to file                     |
590 rem |                                                                          |
592 rem | Increments name from 0 to max 9, then gives up with a burp               |
594 rem + ------------------------------------------------------------------------ +
596 rem | V0.01, pjw, 2019                                                         |
598 rem + ------------------------------------------------------------------------ +
600 :
602 def proc OutPut
604 loc i%, nm$(38), xt$(4)
606 xt$ = '_' & GetExt$(out$)
608 nm$ = out$(1 to len(out$) - len(xt$))
610 er = SaveKeys(nm$ & xt$)
612 for i% = 0 to 9
614  if er = 0 or er <> -8: beep 2000, 2: ret
616  er = SaveKeys(nm$ & i% & xt$)
618 endfor i%
620 if er < 0: beep 2000, 200
622 enddef OutPut
624 :
626 def fn SaveKeys(ofn$)
628 loc ch
630 if len(ofn$) > 41: ret -12
632 ch = fop_in(ofn$)
634 if ch >= 0: close#ch: ret -8
636 if ch <> -7: return ch:         rem SMSQ 3.34 returns -7 on len(fnm$) > 41
638 :
640 ch = fop_over(ofn$)
642 bput#ch; fnm$, 10
644 print#ch; Dis$
646 close#ch
648 ret 0
650 enddef SaveKeys
652 :
654 :
656 rem + ------------------------------------------------------------------------ +
658 rem |<                           Scan for Keywords                            >|
660 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
662 rem |                    Extract keywords from binary file                     |
664 rem |                                                                          |
666 rem | KeyImport - loads binary file                                            |
668 rem | Key       - test-extracts a single keyword                               |
670 rem | Keywords  - adds extracted keyword to a list                             |
672 rem | Pkeys     - subroutine of Keywords; does the actual work                 |
674 rem |                                                                          |
676 rem | GLOBal variables: found%, Names$(), mxkey%, mxkwl%, namechrs$            |
678 rem + ------------------------------------------------------------------------ +
680 rem | V0.01, P Witte May 1995                                                 |
682 rem | V0.10, pjw, 2oi5, No screen output; all to arrays                        |
684 rem | V0.11, pjw, 2019 Jul 27, replaced most home extensions                   |
686 rem | V0.12, pjw, 2023 Jun 20, partial rewrite, and tightening of code         |
688 rem + ------------------------------------------------------------------------ +
690 :
692 def fn KeyImport(fnm$)
694 loc i%, i, ch, sz, adr, madr
696 :
698 ch = fop_in(fnm$): if ch < 0: ret ch
700 sz = FLEN(#ch): close#ch
702 madr = ALCHP(sz): IF madr <= 0: ret -3
704 lbytes fnm$, madr
706 :
708 found% = 0
710 FOR i = madr TO madr + sz - 2 STEP 2
712  IF PEEK_W(i) = 17402 then
714   REMark lea adr,a1
716   adr = peek_w(i + 2)
718   if adr = 0: next i: exit i
720   if ODD(adr): next i: exit i
722   adr = adr + i + 2
724   if Key(adr): Keywords adr
726  END IF
728 END FOR i
730 :
732 RECHP madr
734 ret found%
736 END def KeyImport
738 :
740 :
742 DEFine FuNction Key(ad)
744 LOCal j, a, np, l%, c$(1)
746 a = ad
748 np = PEEK_W(a)
750 IF np < 0 OR np > mxkey%: RETurn 0
752 if np = 0 then
754  rem No Procs. FNs?
756  a = a + 4
758  np = PEEK_W(a)
760  IF np < 0 OR np > mxkey%: RETurn 0
762 END IF
764 a = a + 4:      REMark pass first offset
766 l% = PEEK(a): IF l% = 0 or l% > mxkwl%: RETurn 0: rem Not a name
768 :
770 ret SCanKey
772 END DEFine Key
774 :
776 :
778 def proc Keywords(ad)
780 loc a, j, k, prc$(1)
782 loc l%, f%, t%, n%, c$(1), n$(mxkwl%)
784 :
786 rem     First do procedures
788 IF PEEK_W(ad) > 0 then
790  prc$ = 'P'
792  a = Pkeys(ad + 2)
794 ELSE
796  a = ad + 4
798 END IF
800 :
802 rem     Do Functions
804 IF PEEK_W(a) > 0 THEN
806  prc$ = 'F'
808  a = Pkeys(a + 2)
810 END IF
812 enddef Keywords
814 :
816 :
818 rem + ------------------------------------------------------------------------ +
820 rem |<                                 Pkeys                                  >|
822 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
824 rem |                              Parse Keywords                              |
826 rem |                                                                          |
828 rem | Rewrite to work around Qlib bug that causes program to hang under        |
830 rem | certain circumstances! (I hope!)                                         |
832 rem + ------------------------------------------------------------------------ +
834 rem | V0.18, pjw, 2025 Oct 14                                                  |
836 rem + ------------------------------------------------------------------------ +
838 :
840 DEFine FuNction Pkeys(ad)
842 loc kl, lp
844 a = ad
846 rep kl
848  if peek_w(a) = 0: ret a + 2
850  a = a + 2: l% = peek(a)
852  if l% <= mxkwl% and l% > 1 then
854   if ScanKey then
856    rem Only unique keywords wanted..
858    n$ = n$ & prc$:              rem Encode type into name
860    n% = BSearch%(n$, Names$)
862    if n% < 0: Insert n$, Names$, ABS(n%)
864   endif
866  endif
868  a = EVEN(a + l% + 1)
870 endrep kl
872 ret a + 2
874 enddef Pkeys
876 :
878 :
880 rem + ------------------------------------------------------------------------ +
882 rem |<                                ScanKey                                 >|
884 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
886 rem |                    Sub routine. Uses caller's LOCals                     |
888 rem + ------------------------------------------------------------------------ +
890 rem | V0.01, pjw, 2025 Oct 14                                                  |
892 rem + ------------------------------------------------------------------------ +
894 :
896 deffn ScanKey
898 n$ = ''
900 j = a + 1: k = j + l%
902 rep lp
904  c$ = chr$(peek(j))
906  if not c$ instr namechrs$: ret 0
908  n$ = n$ & c$
910  j = j + 1: if j >= k: ret 1
912 endrep lp
914 end def ScanKey
916 :
918 :
920 rem + ------------------------------------------------------------------------ +
922 rem |<                                Get File                                >|
924 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
926 rem |                             Wrapper for FSEL                             |
928 rem |                                                                          |
930 rem + ------------------------------------------------------------------------ +
932 rem | V0.01, pjw, originally ExExt                                             |
934 rem | V0.04, pjw, 16 Dec 2016                                                  |
936 rem | V0.06, pjw, 2019 Jul 27, re-write for FSEL 0.06                          |
938 rem + ------------------------------------------------------------------------ +
940 :
942 def fn GetFile$(ch, fnmaddr, cl$)
944 loc x%, y%, fnm$(42)
946 loc hl, id, nj, tv%
948 :
950 fnm$ = PEEKSTR$(fnmaddr)
952 :
954 rem EX job, owned by me (If I die, so does FSEL)
956 if fsel$ = '-' then
958  id = fep_m("FSEL"; cl$)
960 else
962  id = FEX_M(fsel$; cl$)
964 endif
966 if len(job$(id)) = 0: ret '': rem FSEL ERRored; code in addr
968 :
970 tv% = 6
972 rep hl
974  rdpt#ch; tv%
976  if len(job$(id)) = 0: exit hl: rem Selection done; FSEL terminated
978                                 rem A little finesse here
980  nj = nxjob(id, 0)
982                                 rem If FSEL asleep..
984  if asleep$ instr job$(nj) then
986   if tv% div 256 then
988    rjob nj, 0: beep 2000,2:     rem If a key pressed, WAKE
990   else
992    next hl:                     rem Otherwise ignore
994   endif
996  endif
998  ptop#ch; id:                   rem Always pick FSEL on top unltil done
1000 endrep hl
1002 ptop#ch; jobid:                 rem Done! Now me on top!
1004 :
1006 ret PEEKSTR$(fnmaddr):          rem Return file name (or, rarely, error)
1008 END DEFine GetFile$
1010 :
1012 :
1014 rem + ------------------------------------------------------------------------ +
1016 rem |<                             Get Extension                              >|
1018 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1020 rem | Extract the extension from a filename                                    |
1022 rem | Not 100% foolproof! Extension length betw 1 and 4 char                   |
1024 rem | Separator . or _  (is not included in return)                            |
1026 rem | If it doesnt like what it sees, or there is no ext, returns ''           |
1028 rem + ------------------------------------------------------------------------ +
1030 rem | V0.01, pjw, mists of time..                                              |
1032 rem | V0.03, pjw, February 11th 2018                                           |
1034 rem + ------------------------------------------------------------------------ +
1036 :
1038 DEFine FuNction GetExt$(fnm$)
1040 LOCal i%, l%
1042 l% = LEN(fnm$)
1044 IF l% >= 3 THEN
1046  FOR i% = l% TO l% - 4 STEP -1
1048   IF fnm$(i%) INSTR '_.': RETurn fnm$(i% + 1 TO l%)
1050  END FOR i%
1052 END IF
1054 RETurn ''
1056 END DEFine GetExt$
1058 :
1060 :
1062 rem + ------------------------------------------------------------------------ +
1064 rem |<                                BSearch                                 >|
1066 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1068 rem |                              Binary Search                               |
1070 rem |                                                                          |
1072 rem | Returns position if found, or -position where item should go. Thus it    |
1074 rem | can be used to add new, unique items to a list, in alphabetical order.   |
1076 rem |                                                                          |
1078 rem | Arrays indexed from 1..                                                  |
1080 rem | Designed for numeric data but can be used for CASE-dependent strings     |
1082 rem + ------------------------------------------------------------------------ +
1084 rem | V0.01, pjw, 1996+, From TAOCP 6.2.1                                      |
1086 rem | V0.02, pjw, 2021 Jun 30, Numeric version; integers and floats            |
1088 rem | V0.02, pjw, 2023 Jun 20, Modyfied for KeyScanner                         |
1090 rem + ------------------------------------------------------------------------ +
1092 :
1094 DEFine FuNction BSearch%(item, Arr)
1096 LOCal loop, u%, l%, i%
1098 l% = 0: u% = found%
1100 REPeat loop
1102  IF u% < l%: i% = -l%: EXIT loop:               rem Not found here
1104  i% = INT((l% + u%) / 2)
1106  IF item = Arr(i%): EXIT loop
1108  IF item < Arr(i%) THEN
1110   u% = i% - 1
1112  ELSE
1114   l% = i% + 1
1116  END IF
1118 END REPeat loop
1120 RETurn i%
1122 END DEFine BSearch%
1124 :
1126 :
1128 rem + ------------------------------------------------------------------------ +
1130 rem |<                                 Insert                                 >|
1132 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1134 rem |            Insert item in an array at given position, 0..DIMN            |
1136 rem |                                                                          |
1138 rem | Item and array can be of any type                                        |
1140 rem |                                                                          |
1142 rem | GLOBal found%                                                            |
1144 rem + ------------------------------------------------------------------------ +
1146 rem | V0.01, pjw, 2017 Mar                                                     |
1148 rem | V0.02, pjw, 2021 Jun 30, Simplified                                      |
1150 rem | V0.02, pjw, 2023 Jun 20, Modyfied for KeyScanner                         |
1152 rem + ------------------------------------------------------------------------ +
1154 :
1156 DEFine PROCedure Insert(item, Arr, at%)
1158 LOCal i%
1160 found% = found% + 1
1162 IF at% < found% THEN
1164  FOR i% = found% TO at% + 1 STEP -1
1166   Arr(i%) = Arr(i% - 1)
1168  END FOR i%
1170 END IF
1172 Arr(at%) = item
1174 END DEFine Insert
1176 :
1178 :
1180 rem + ------------------------------------------------------------------------ +
1182 rem |<                              Set Arrow/Bar                             >|
1184 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1186 rem |           Set AW arrow and bar colours, omitted by EasyPointer           |
1188 rem |                                                                          |
1190 rem + ------------------------------------------------------------------------ +
1192 rem | V0.00, Bob Spelten                                                       |
1194 rem | V0.01, pjw, November 7th 2017                                            |
1196 rem | V0.02, pjw, 2019 Jul 29, re-write. Still not working :o(                 |
1198 rem + ------------------------------------------------------------------------ +
1200 :
1202 def proc SetScroll(ch, aw%)
1204 loc wwd, awl, awa, csy
1206 wwd = mwdef(#ch)
1208 awl = peek_l(wwd + ww_pappl):            rem Get AW list
1210 :
1212 if peek_w(wwd + ww_nappl) < aw%: return: rem None or too few
1214 awa = peek_l(awl + (aw% - 1) * 4):       rem awa -> to aw%
1216 :
1218 if peek_w(awa + wwa_nysc) = 0: return:   rem No y-control section
1220 csy =  awa + wwa_clen%:                  rem csy -> the one we want
1222 poke_w csy + wwa_psac, sp_scrbararr%:    rem scroll arrow colour
1224 poke_w csy + wwa_psbc, sp_scrbar%:       rem scroll bar colour
1226 poke_w csy + wwa_pssc, sp_scrbarsec%:    rem scroll section colour
1228 enddef SetScroll
1230 :
1232 :
1234 rem + ------------------------------------------------------------------------ +
1236 rem |<                               GetConfig                                >|
1238 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1240 rem |                Standard, configurable config file reader                 |
1242 rem |                                                                          |
1244 rem + ------------------------------------------------------------------------ +
1246 rem | V0.05, pjw, 2017 Jun                                                     |
1248 rem | V0.06, pjw, 2019 Jul 29, Keywords-specific                               |
1250 rem + ------------------------------------------------------------------------ +
1252 :
1254 def fn GetConfig
1256 loc ch, er, p%, lp, l$, t$, pl$
1258 :
1260 ch = CheckID(root$ & cfg$, 'KWCF01', 0)
1262 if ch < 0: ret ch
1264 :
1266 fsel$   =     '':       rem File selector
1268 out$    =     '':       rem Output file
1270 dir$    =     '':       rem Default start directory
1272 ext$    = '_bin':       rem Default extension
1274 fwid%    =   400:       rem FSEL width
1276 hite%   =    400:       rem FSEL height
1278 palette =      0:       rem Default palette
1280 asleep$ = ' asleep':    rem Asleep job name in English
1282 :
1284 rep lp
1286  if eof(#ch): exit lp
1288  input#ch; l$
1290  if len(l$) = 0: next lp
1292  if l$(1) = '*': next lp
1294  t$ = GtCfgIt$("fsel "):    if len(t$)    :   fsel$   = t$: next lp
1296  t$ = GtCfgIt$("defd "):    if len(t$)    :   dir$    = t$: next lp
1298  t$ = GtCfgIt$("outf "):    if len(t$)    :   out$    = t$: next lp
1300  t$ = GtCfgIt$("width "):   if VALID%(3, t$): fwid%   = t$: next lp
1302  t$ = GtCfgIt$("hight "):   if VALID%(3, t$): hite%   = t$: next lp
1304  t$ = GtCfgIt$("palette "): if VALID%(3, t$): palette = t$: next lp
1306  t$ = GtCfgIt$("asleep "):  if len(t$): asleep$  = ' ' & t$: next lp
1308 endrep lp
1310 close#ch
1312 :
1314 if fsel$ <> '-' then
1316  if fsel$ = '*': fsel$ = root$
1318  fsel$ = fsel$ & 'FSEL_obj'
1320  er = ftest(fsel$): if er: ret er
1322 endif
1324 :
1326 if len(dir$) < 5: ret -12
1328 dev$ = dir$(1 to 5)
1330 ch = fop_dir(dir$): if ch < 0: ret ch
1332 dir$ = dev$ & fname$(#ch): close#ch
1334 AddUnder dir$
1336 :
1338 if len(out$) < 8: ret -12
1340 t$ = GetExt$(out$)
1342 if len(t$) = 0: out$ = out$ & '_txt'
1344 :
1346 ret 0
1348 enddef GetConfig
1350 :
1352 rem + ------------------------------------------------------------------------ +
1354 rem |<                                GtCfgIt$                                >|
1356 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1358 rem | Get single Config Item (Subroutine of GetConfig)                         |
1360 rem + ------------------------------------------------------------------------ +
1362 :
1364 def fn GtCfgIt$(it$)
1366 if (it$ instr l$) <> 1: ret ''
1368 p% = '=' instr l$
1370 if p% = 0: ret ''
1372 t$ = DETAB$(l$(p% + 1 to len(l$)))
1374 for p% = 1 to len(t$)
1376  if t$(p%) = ' ': p% = p% - 1: exit p%
1378 endfor p%
1380 ret t$(1 to p%)
1382 enddef GtCfgIt$
1384 :
1386 :
1388 rem + ------------------------------------------------------------------------ +
1390 rem |<                                CheckID                                 >|
1392 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1394 rem | Open an IDed file and check for correct ID                               |
1396 rem |                                                                          |
1398 rem | If ok, return its open channel, with file pointer just past ID           |
1400 rem | io parameter: 0 = read only, 1 => read/write                             |
1402 rem + ------------------------------------------------------------------------ +
1404 :
1406 def fn CheckID(fnm$, id$, io)
1408 loc ch, p%, c$
1410 if io then
1412  ch = fopen(fnm$)
1414 else
1416  ch = fop_in(fnm$)
1418 endif
1420 if ch < 0: ret ch
1422 for p% = 1 to len(id$)
1424  c$ = inkey$(#ch; 50)
1426  if eof(#ch) or len(c$) = 0 or c$ <> id$(p%) then
1428   close#ch: ret -12: rem Not our config file
1430  endif
1432 endfor p%
1434 ret ch
1436 enddef CheckID
1438 :
1440 :
1442 rem + ------------------------------------------------------------------------ +
1444 rem |<                                AddUnder                                >|
1446 rem + ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ +
1448 rem |                   Add directory underscore, if needed                    |
1450 rem |                                                                          |
1452 rem + ------------------------------------------------------------------------ +
1454 :
1456 def proc AddUnder(r.drv$)
1458 if r.drv$(len(r.drv$)) <> '_': r.drv$ = r.drv$ & '_'
1460 enddef AddUnder
1462 :
1464 :
